import pandas as pd
import numpy as np
import os

def analisi_outliers_IQR(feature):
    Q1 = np.percentile(feature, 25)
    Q3 = np.percentile(feature, 75)
    IQR = Q3 - Q1    
    limite_inferiore = Q1 - (1.5 * IQR)
    limite_superiore = Q3 + (1.5 * IQR)
    outliers = (feature < limite_inferiore) | (feature > limite_superiore)
    perc_outliers_IQR = np.sum(outliers) / len(feature) * 100
    return perc_outliers_IQR

def analizza_outliers(path_pazienti_F, path_pazienti_I, output_dir):
    os.makedirs(output_dir, exist_ok=True)

    # Liste per raccogliere i risultati
    outliers_list_F = []
    outliers_list_I = []

    def analizza_dataset(dataset, outliers_list):
        for paziente in dataset:
            paz_i = pd.read_csv(paziente)
            nome_paziente = os.path.basename(paziente).split('_')[0]

            for col in paz_i.columns:
                feature_values = paz_i[col].dropna().values
                if feature_values.size < 2 or np.std(feature_values) == 0:
                    continue
                perc_outliers_IQR = analisi_outliers_IQR(feature_values)
                outliers_list.append([nome_paziente, col, perc_outliers_IQR])

    # Analizza dataset F e I
    dataset_F = [os.path.join(path_pazienti_F, f) for f in os.listdir(path_pazienti_F) if f.endswith('.csv')]
    dataset_I = [os.path.join(path_pazienti_I, f) for f in os.listdir(path_pazienti_I) if f.endswith('.csv')]

    analizza_dataset(dataset_F, outliers_list_F)
    print("Analisi outliers Dataset F completata!")
    analizza_dataset(dataset_I, outliers_list_I)
    print("Analisi outliers Dataset I completata!")
    
    # Creazione DataFrame aggregato
    df_outliers_F = pd.DataFrame(outliers_list_F, columns=["Paziente", "Feature", "%_out_IQR"])
    df_outliers_I = pd.DataFrame(outliers_list_I, columns=["Paziente", "Feature", "%_out_IQR"])

    # Pivot per avere pazienti come righe e feature come colonne
    tabella_outliers_F = df_outliers_F.pivot(index="Paziente", columns="Feature", values="%_out_IQR").fillna(0)
    tabella_outliers_I = df_outliers_I.pivot(index="Paziente", columns="Feature", values="%_out_IQR").fillna(0)

    # Salvataggio tabelle finali
    tabella_outliers_F.to_excel(os.path.join(output_dir, "outliers_riepilogo_F.xlsx"))
    tabella_outliers_I.to_excel(os.path.join(output_dir, "outliers_riepilogo_I.xlsx"))

    print("Analisi outliers completata! File Excel salvati in:", output_dir)

# Esempio di utilizzo:
# analizza_outliers("C:/Percorso/Dataset_F", "C:/Percorso/Dataset_I", "C:/Percorso/output_outlier_IQR")
